#ifndef _WORDFILTER_SONY_H
#define _WORDFILTER_SONY_H

#include "UnityNP.h"
#include "Mutex.h"
#include <string>

namespace UnityPlugin
{
	typedef sce::Toolkit::NP::WordFilterParam WORDFILTERPARAM;

	struct FilteredComment
	{
		bool wasChanged;
		const char* comment;
	};

	PRX_EXPORT bool PrxWordFilterIsBusy();
	PRX_EXPORT bool PrxWordFilterGetLastError(ResultCode* result);
	PRX_EXPORT ErrorCode PrxWordFilterCensorComment(const char* comment);
	PRX_EXPORT ErrorCode PrxWordFilterSanitizeComment(const char* comment);
	PRX_EXPORT ErrorCode PrxWordFilterGetResult(FilteredComment* result);

	class CachedWordFilter
	{
	private:
		SimpleLock m_Lock;
		std::string m_FilteredComment;
		bool m_Busy;
		ResultCode m_LastResult;
		bool m_CommentWasChanged;
		WORDFILTERPARAM* m_WordFilterParam;

		sce::Toolkit::NP::Utilities::Future<sce::Toolkit::NP::WordFilterSanitized> m_FutureSanitized;

	public:
		CachedWordFilter();
		~CachedWordFilter();
		bool IsBusy();
		ErrorCode GetLastError() const { return m_LastResult.GetResult(); }
		bool GetLastError(ResultCode* result) const { *result = m_LastResult; return m_LastResult.GetResult() == NP_OK; }
		ErrorCode GetResult(FilteredComment* result);
		bool ProcessEvent(const sce::Toolkit::NP::Event& event);
		ErrorCode SanitizeComment(const char* comment);
		ErrorCode CensorComment(const char* comment);
	};

	extern CachedWordFilter gWordFilter;
}

#endif // _WORDFILTER_SONY_H
